VERSION 8000; ; 8414

* -----------------------------------------------------------------------------
* @filedoc
* @file ZG_StrassenQuerschnitt.CSX
* @brief Querschnittszeichnung im Dialog erstellen
* 
* Dieses Beispielskript erstellt auf Basis der Einfge-Dateien zur RE-Darstellung
* eine Querschnittzeichnung.
*
* Mchten Sie andere Parameter verwenden, so passen Sie diese im Skript an 
* Genauso knnen Sie dieses Skript um eigene Parameter ergnzen. 
*
* Voraussetzungen:
* ----------------
* Fr die Erstellung der Querschnittzeichnung mssen folgende Dateien im Projekt CARDDEMO
* oder im zentralen Projekt vorhanden sein:
*
*   - RAS_VERM.STF: Stifttabelle
*   - STEMP.PLT mit Objekt "Stempel"
*   - Die Profillinie 10 muss mindestens vorhanden sein
*
* Ergebnisse:
* ----------- 
* Es wird eine Vereinbarung fr Querschnittzeichnungen (Datei: PPLaaann.CRD) angelegt und ausgefhrt.
* Die erzeugte Querschnittzeichnung wird anschlieend angezeigt.
*  
* -----------------------------------------------------------------------------
* Copyright (C) IB&T
* 
* Gewhrleistung und Nutzung
* 
* Die Nutzung des Skriptes erfolgt stets auf eigene Gefahr. IB&T bernimmt keine
* Gewhr dafr, dass die Nutzung dieses Skriptes zu Ihrem gewnschten Ergebnis
* fhrt. Da CardScripte vorhandene Projektdaten durch Direktzugriff auf die
* jeweiligen Datenbanken auch ohne weitere Sicherheitsabfragen unbemerkt verndern
* oder lschen knnen, erfordert eine Nutzung entsprechende Kenntnisse und groe
* Sorgfalt. IB&T haftet nicht fr eventuell entstehende Datenverluste und
* Folgeschden, die durch die Nutzung von CardScripten entstehen.
*
* -----------------------------------------------------------------------------
* @author JH
* @endfiledoc
* -----------------------------------------------------------------------------
*    8414 09.01.13 JH Auf neue Dialoge umgestellt lauffhig ab Version 8.414 (wegen DLG_CRD)
*                     Umstellung auf Hilfesystem
* @history
* -----------------------------------------------------------------------------

BENUTZE "<CARD>MASKFELD.QPR"   | benutzt Funktionsblcke
BILDSCHIRM GRAFIK              | gibt die Meldungen im Arbeitsprotokoll aus

SYMBOLE * Ax_Nr;Dat_Nr;ASTAT;ESTAT
SYMBOLE * !DatNam;Ret;Frageret
SYMBOLE * !Projektbez;!Strae;!vonKm;!bisKm;!Ort;!Zeichnung;!Amt;!Bearbeitet;!Gezeichnet;!DatBearb;!DatGezei;!Masstab;!BlNr       

* --- Zuweisungen -------------------------------------------------------------

Ax_Nr = 1
Dat_Nr = 99                    | Nummer der Zeichnungsvereinbarung


!Dat_Typ = "PPL" 
!Bez     = "ber CardScript erzeugte Vereinbarung"

* aktuelle Texte fr Stempelobjekt
!Projektbez = "Projektbezeichnung"
!Strae     = "Hauptstrae"
!vonKm      = "0,0"
!bisKm      = "1000,00"
!Ort        = "Ort"
!Zeichnung  = "Querschnitt"
!Amt        = "Amt  "
!Bearbeitet = "Bearbeiter"
!Gezeichnet = "Zeichner"
!DatBearb   = "Mrz 2009"
!DatGezei   = "Mai 2009"
!Masstab    = "1:100"
!BlNr       = "1"

* --- Ausfhrungen ------------------------------------------------------------
RET = DIALOG()
WENN RET == 0 DANN STOP
* ... Dialoglayout


* ... Aufruf Dialog zum Bearbeiten der Textvariablen 

MELDUNG FRAGE; "Aktuelle Texte fr Stempelfeld eingeben?"; FrageRet
WENN FrageRet == 1 DANN 
  Ret = Stempel_Dialog()
  WENN RET == 0 DANN STOP
WEITER
* ----------------------------------------------------------


* bildet den Dateinamen fr die Zeichnungsvereinbarung
!DatNam = !CRDNAME(!Dat_Typ; Ax_Nr; Dat_Nr)

* legt einen neue Vereinbarungsdatei an
DAT_NEU 1; NAME = !DatNam; BEZ = !Bez; DEZ = "COMMA"

* schreibt Inhalte in die Vereinbarungsdatei
DAT_SCHREIBEN 1; "VERSION 8000"
DAT_SCHREIBEN 1; "* generierte Vereinbarung fr Querschnittszeichnungen"              
DAT_SCHREIBEN 1; "* -------------------------------------------------- "
DAT_SCHREIBEN 1; " "
DAT_SCHREIBEN 1; "ZRAND A3_QUER_M"
DAT_SCHREIBEN 1; "STEMPEL '<?>STEMP.PLT>STEMPEL'; 0,5; 0,5"
DAT_SCHREIBEN 1; "* -------------------------------------------------- " 
DAT_SCHREIBEN 1; "* definiert Textvariablen, um Platzhaltertexte im Stempelobjekt mit aktuellen Texten zu versehen"
DAT_SCHREIBEN 1; "TEXTVARIABLE Projektbez; '#'"; !ProjektBez 
DAT_SCHREIBEN 1; "TEXTVARIABLE Strae; '#'"; !Strae     
DAT_SCHREIBEN 1; "TEXTVARIABLE vonKm; '#'"; !vonKm      
DAT_SCHREIBEN 1; "TEXTVARIABLE bisKm; '#'"; !bisKm      
DAT_SCHREIBEN 1; "TEXTVARIABLE Ort; '#'"; !Ort        
DAT_SCHREIBEN 1; "TEXTVARIABLE Zeichnung; '#'"; !Zeichnung  
DAT_SCHREIBEN 1; "TEXTVARIABLE Amt; '#'"; !Amt        
DAT_SCHREIBEN 1; "TEXTVARIABLE Bearbeitet; '#'"; !Bearbeitet 
DAT_SCHREIBEN 1; "TEXTVARIABLE Gezeichnet; '#'"; !Gezeichnet 
DAT_SCHREIBEN 1; "TEXTVARIABLE DatBearb; '#'"; !DatBearb   
DAT_SCHREIBEN 1; "TEXTVARIABLE DatGezei; '#'"; !DatGezei   
DAT_SCHREIBEN 1; "TEXTVARIABLE Masstab; '#'"; !Masstab    
DAT_SCHREIBEN 1; "TEXTVARIABLE BlNr; '#'"; !BlNr     
DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; "* Zuweisungen"


DAT_SCHREIBEN 1; "* Blattgroesse"
DAT_SCHREIBEN 1; "* Die Profile sollen auf Einzelblaetter mit der DIN-Hoehe 29.7"
DAT_SCHREIBEN 1; "* gezeichnet werden. Das Plotterpapier ist 120cm lang und 84cm breit."

DAT_SCHREIBEN 1; "BLATT 120,;84,;29,7"

DAT_SCHREIBEN 1; "* Blattnummer im Stempelfeld rechts unten positionieren"
DAT_SCHREIBEN 1; "* Das Blatt mit der Station 520 soll die Nummer 22 bekommen."

DAT_SCHREIBEN 1; "BLATTNUMMER 22;17,;0,28;0,2;0,35"

DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; "*  Standard-Massstab fr Breite,Hoehe: 1:100"
DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; "*  Stationsbereich"
DAT_SCHREIBEN 1; "*  Es werden hier alle Stationen in diesem Bereich beruecksichtigt,"
DAT_SCHREIBEN 1; "*  welche die Linien 10 enthalten."
DAT_SCHREIBEN 1; "* --------------------------------------------------- " 

DAT_SCHREIBEN 1; "STATION #.###;#.###";ASTAT;ESTAT
DAT_SCHREIBEN 1; "DEFOBJEKT 'Flaechen';'Flchenfllungen'"
DAT_SCHREIBEN 1; "DEFOBJEKT 'Profillinien';'alle Profillinien vom Querschnitt'"
DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; "*  Profil, ProfillinienNr., Stift, Strichart"
DAT_SCHREIBEN 1; "*  hierfuer gilt: 12 = Gelaende"
DAT_SCHREIBEN 1; "*                 10 = gepl. Strasse Oberflaeche"
DAT_SCHREIBEN 1; "*                 11 = Profillinie fuer Mutterbodenabtrag"
DAT_SCHREIBEN 1; "*                 13 = Planum"
DAT_SCHREIBEN 1; "*                 14 = Frostschutzschicht"
DAT_SCHREIBEN 1; "*                 15 = Tragschicht"
DAT_SCHREIBEN 1; "*                 16 = Decke"
DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; " "
DAT_SCHREIBEN 1; "TABELLEN LTABELLE:J;PTABELLE:J"
DAT_SCHREIBEN 1; "PROFLISTE 10;12;11;13;14;15;16;17" 
DAT_SCHREIBEN 1; " "

DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; "DEFOBJEKT 'Flaechen';'Flchenfllungen'"
DAT_SCHREIBEN 1; "* Flchenfllungen"
DAT_SCHREIBEN 1; "LMUSTER  10;13;70"
DAT_SCHREIBEN 1; "LMUSTER  13;16;67"
DAT_SCHREIBEN 1; "LMUSTER  16;23;106"
DAT_SCHREIBEN 1; "LMUSTER  23;25;80"
DAT_SCHREIBEN 1; "LMUSTER  25;30;1;;;0;0;0;"

DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; "*  Bemassung, Text, Profillinie, Genauigkeit (2)"
DAT_SCHREIBEN 1; "DEFOBJEKT 'Bemassung';'alle Bemassungsksten'"
DAT_SCHREIBEN 1; " "
DAT_SCHREIBEN 1; "BEMASSUNG 'PROJEKT';10"
DAT_SCHREIBEN 1; "BEMASSUNG '2.TRAGSCHICHT';14"
DAT_SCHREIBEN 1; "BEMASSUNG 'PLANUM';13"
DAT_SCHREIBEN 1; "BEMASSUNG 'GELAENDE';12"
DAT_SCHREIBEN 1; "BEMASSUNG 'OBERBODENABTRAG';11"
DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; "DEFOBJEKT 'Beschriftung';'Fahrstreifen'"
DAT_SCHREIBEN 1; "* Beschriftungstexte"
DAT_SCHREIBEN 1; "SCHRIFT  0;0,25"
DAT_SCHREIBEN 1; "STIFTE 1;2;3"
DAT_SCHREIBEN 1; "TBESCHRIFTUNG 'Bankett';((TN(10;-12)+TN(10;-15))/2); (ZN(10;1)+ 2);;;300" 
DAT_SCHREIBEN 1; "WBESCHRIFTUNG ABS((TN(10;-15)-TN(10;-12)));((TN(10;-15)+TN(10;-12))/2); (ZN(10;1)+ 3,5)"
DAT_SCHREIBEN 1; "TBESCHRIFTUNG 'Fahrstreifen';((TN(10;-12)+TN(10;1))/2); (ZN(10;1)+ 3)"
DAT_SCHREIBEN 1; "WBESCHRIFTUNG ABS((TN(10;-12)-TN(10;1)));((TN(10;-12)+TN(10;1))/2); (ZN(10;1)+ 3,5)"
DAT_SCHREIBEN 1; "TBESCHRIFTUNG 'Fahrstreifen';((TN(10;1)+TN(10;12))/2); (ZN(10;1)+ 3)" 
DAT_SCHREIBEN 1; "WBESCHRIFTUNG ABS((TN(10;1)-TN(10;12)));((TN(10;1)+TN(10;12))/2); (ZN(10;1)+ 3,5)"
DAT_SCHREIBEN 1; "TBESCHRIFTUNG 'Bankett'; ((TN(10;12)+TN(10;15))/2); (ZN(10;1)+ 2);;;300"
DAT_SCHREIBEN 1; "WBESCHRIFTUNG ABS((TN(10;12)-TN(10;15)));((TN(10;12)+TN(10;15))/2); (ZN(10;1)+ 3,5)"
DAT_SCHREIBEN 1; "*WBESCHRIFTUNG NEIGUNG(10;1); TN(10;1);ZN(10;1)+0,1; '#.## %'"
DAT_SCHREIBEN 1; "NEIGUNG 10;-12;12; ;1;1"
DAT_SCHREIBEN 1; "WBESCHRIFTUNG ABS((TN(10;-14)-TN(10;14)));((TN(10;-14)+TN(10;14))/2); (ZN(10;1)+ 5,5)"
DAT_SCHREIBEN 1; "* --------------------------------------------------- " 
DAT_SCHREIBEN 1; 'DEFOBJEKT "Hilflinien";"Hilfslinien"'
DAT_SCHREIBEN 1; "* Hilfslinie Senkrecht"
DAT_SCHREIBEN 1; "LINIE  TN(10;-15); ZN(10;1)+ 2,5; TN(10;-15);ZN(10;1)+ 5,5;1;0"
DAT_SCHREIBEN 1; "LINIE  TN(10;-12); ZN(10;1)+ 2,5; TN(10;-12);ZN(10;1)+ 3,5;1;0"
DAT_SCHREIBEN 1; "LINIE  TN(10;1); ZN(10;1)+ 2,5; TN(10;1);ZN(10;1)+ 3,5;1;0"
DAT_SCHREIBEN 1; "LINIE  TN(10;12); ZN(10;1)+ 2,5; TN(10;12);ZN(10;1)+ 3,5;1;0"
DAT_SCHREIBEN 1; "LINIE  TN(10;15); ZN(10;1)+ 2,5; TN(10;15);ZN(10;1)+ 5,5;1;0"
DAT_SCHREIBEN 1; "* Hilfslinie Horizontal"
DAT_SCHREIBEN 1; "LINIE  TN(10;-15); ZN(10;1)+ 5,0; TN(10;15);ZN(10;1)+ 5,0;1;0"
DAT_SCHREIBEN 1; "LINIE  TN(10;-15); ZN(10;1)+ 3,3; TN(10;15);ZN(10;1)+ 3,3;1;0"
DAT_SCHREIBEN 1; "* Ergnzungen wenn Mulde vorhanden"
DAT_SCHREIBEN 1; " "
DAT_SCHREIBEN 1; "DEFOBJEKT 'Symbole';'Ergnzende Symbole'"
DAT_SCHREIBEN 1; "SYMBOL  19; TN(10;-15); ZN(10;1)+ 3,3 ; 0,5 ; 0; 1; 0,5"
DAT_SCHREIBEN 1; "SYMBOL  19; TN(10;-12); ZN(10;1)+ 3,3 ; 0,5 ; 0; 1; 0,5"
DAT_SCHREIBEN 1; "SYMBOL  19; TN(10;1); ZN(10;1)+ 3,3 ; 0,5 ; 0; 1; 0,5"
DAT_SCHREIBEN 1; "SYMBOL  19; TN(10;12); ZN(10;1)+ 3,3 ; 0,5 ; 0; 1; 0,5"
DAT_SCHREIBEN 1; "SYMBOL  19; TN(10;15); ZN(10;1)+ 3,3 ; 0,5 ; 0; 1; 0,5"
DAT_SCHREIBEN 1; " "
DAT_SCHREIBEN 1; "SYMBOL  19; TN(10;-15); ZN(10;1)+ 5,0 ; 0,5 ; 0; 1; 0,5"
DAT_SCHREIBEN 1; "SYMBOL  19; TN(10;15); ZN(10;1)+ 5,0 ; 0,5 ; 0; 1; 0,5"



* schliet die Vereinbarungsdatei
DAT_ZU 1

* startet die Funktionsgruppe "Querschnittszeichnung erstellen" und
* fhrt die Zeichnungsvereinbarung aus
STARTE PROFPLOT; ; "AX = ###; NR = ##; AUSF"; Ax_Nr; Dat_Nr
* Alternativ: erzeugt die Zeichnung ohne Starten der Funktionsgruppe
* STARTE "RUN_GRADPLOT@GRADPLOT.DLL"; ; "AX = ###; NR = ##; AUSF"; Ax_Nr; Dat_Nr

STOP


* -----------------------------------------------------------------------------
* @function Dialog
* @brief Dialog 
*
* @ingroup
* @author JH
* @endfunction
FUNKTION Dialog:
  EXTERN * Ax_Nr;Dat_Nr;ASTAT;ESTAT
  EXTERN * !DatNam;Ret

  SYMBOLE /DLG_WINDOW/     DIALOG
  SYMBOLE /DLG_ALIGNMENT/  Achse
  SYMBOLE /DLG_CRD/        DNR
  Symbols /DLG_CHAINAGERANGE/ Bereich

  DIALOG = NEWOBJECT /DLG_WINDOW/


  Dialog.SetCaption("Querschittzeichnung erstellen")
  Dialog.SetHelp("Allgemein")

  Achse = NewObject /DLG_ALIGNMENT/
  Achse.SetNumber(Ax_Nr)
  Achse.SetLabel("Achse:")
  Dialog.AddField(Achse)

  DNR = NewObject /DLG_CRD/
  DNR.SetType(!Dat_Typ)
  DNR.SetLabel("Nr.:")
  DNR.SetNumber(Dat_Nr) 
  DNR.SetDescription(!Bez)
  DNR.EnableNew()
  DNR.SetAlignmentField(Achse)
  Dialog.AddField(DNR)

  *   Stationsbereich
  Bereich = NewObject /DLG_CHAINAGERANGE/
*  Bereich.SetStartChainage(ASTAT)
*  Bereich.SetEndChainage(ESTAT)
  Bereich.SetLabel("Bereich:")
  Bereich.SetAlignmentField(Achse)
  Dialog.AddField(Bereich)

  Ret = Dialog.DoDialog(1)

  WENN Ret DANN
    Ax_Nr  = Achse.GetNumber()
    Dat_Nr = DNR.GetNumber()
    !Bez =   DNR.GetDescription()
    ASTAT = Bereich.GetStartChainage()
    ESTAT = Bereich.GetEndChainage()
  WEITER
  ZURCK RET
ENDE FUNKTION


* -----------------------------------------------------------------------------
* @function Stempel_Dialog
* @brief Dialog fr Textvariablen
*
* @ingroup
* @author JH
* @endfunction
FUNKTION Stempel_Dialog:

  EXTERN * !Projektbez;!Strae;!vonKm;!bisKm;!Ort;!Zeichnung;!Amt;!Bearbeitet;!Gezeichnet;!DatBearb;!DatGezei;!Masstab;!BlNr       
  SYMBOLE * Ret;FLang;Tlang
  SYMBOLE /DLG_WINDOW/ DIALOG
  SYMBOLE /DLG_TEXT/   TextFeld(13)

  DIALOG =   NEWOBJECT /DLG_WINDOW/

  FLang = 80
  TLang = 100 
  DIALOG.SetSize(FLang )
    
  Dialog.SetCaption("Aktuelle Texte fr Stempelfeld")
  Dialog.SetHelp("Allgemein")

  TextFeld(1) = NewObject /DLG_Text/   
  TextFeld(1).SetSize(FLang;TLang)
  TextFeld(1).SetLabel("Projektbezeichnung:")
  TextFeld(1).SetText(!Projektbez)
  Dialog.AddField(TextFeld(1))

  TextFeld(2) = NewObject /DLG_Text/   
  TextFeld(2).SetSize(FLang;TLang)
  TextFeld(2).SetLabel("Strae:")
  TextFeld(2).SetText(!Strae)
  Dialog.AddField(TextFeld(2))

  TextFeld(3) = NewObject /DLG_Text/   
  TextFeld(3).SetSize(FLang;TLang)
  TextFeld(3).SetLabel("von km:")
  TextFeld(3).SetText(!vonKm)   
  Dialog.AddField(TextFeld(3))

  TextFeld(4) = NewObject /DLG_Text/   
  TextFeld(4).SetSize(FLang;TLang)
  TextFeld(4).SetLabel("bis km:")
  TextFeld(4).SetText(!bisKm)     
  Dialog.AddField(TextFeld(4))

  TextFeld(5) = NewObject /DLG_Text/   
  TextFeld(5).SetSize(FLang;TLang)
  TextFeld(5).SetLabel("Ort:")
  TextFeld(5).SetText(!Ort)       
  Dialog.AddField(TextFeld(5))

  TextFeld(6) = NewObject /DLG_Text/   
  TextFeld(6).SetSize(FLang;TLang)
  TextFeld(6).SetLabel("Zeichnung:")
  TextFeld(6).SetText(!Zeichnung) 
  Dialog.AddField(TextFeld(6))

  TextFeld(7) = NewObject /DLG_Text/   
  TextFeld(7).SetSize(FLang;TLang)
  TextFeld(7).SetLabel("Amt:")
  TextFeld(7).SetText(!Amt)       
  Dialog.AddField(TextFeld(7))

  TextFeld(8) = NewObject /DLG_Text/   
  TextFeld(8).SetSize(FLang;TLang)
  TextFeld(8).SetLabel("bearbeitet, Name:")
  TextFeld(8).SetText(!Bearbeitet)
  Dialog.AddField(TextFeld(8))

  TextFeld(9) = NewObject /DLG_Text/   
  TextFeld(9).SetSize(FLang;TLang)
  TextFeld(9).SetLabel("gezeichnet, Name:")
  TextFeld(9).SetText(!Gezeichnet)
  Dialog.AddField(TextFeld(9))

  TextFeld(10) = NewObject /DLG_Text/   
  TextFeld(10).SetSize(FLang;TLang)
  TextFeld(10).SetLabel("bearbeitet, Datum:")
  TextFeld(10).SetText(!DatBearb)  
  Dialog.AddField(TextFeld(10))

  TextFeld(11) = NewObject /DLG_Text/   
  TextFeld(11).SetSize(FLang;TLang)
  TextFeld(11).SetLabel("gezeichnet, Datum:")
  TextFeld(11).SetText(!DatGezei)  
  Dialog.AddField(TextFeld(11))

  TextFeld(12) = NewObject /DLG_Text/   
  TextFeld(12).SetSize(FLang;TLang)
  TextFeld(12).SetLabel("Mastab:")
  TextFeld(12).SetText(!Masstab)   
  Dialog.AddField(TextFeld(12))

  TextFeld(13) = NewObject /DLG_Text/   
  TextFeld(13).SetSize(FLang;TLang)
  TextFeld(13).SetLabel("Blattnummer:")
  TextFeld(13).SetText(!BlNr)      
  Dialog.AddField(TextFeld(13))
    
  Ret = Dialog.DoDialog(1)
    
  WENN Ret DANN
      !Projektbez = TextFeld(1).GetText()
      !Strae     = TextFeld(2).GetText()
      !vonKm      = TextFeld(3).GetText()
      !bisKm      = TextFeld(4).GetText()
      !Ort        = TextFeld(5).GetText()
      !Zeichnung  = TextFeld(6).GetText()
      !Amt        = TextFeld(7).GetText()
      !Bearbeitet = TextFeld(8).GetText()
      !Gezeichnet = TextFeld(9).GetText()
      !DatBearb   = TextFeld(10).GetText()
      !DatGezei   = TextFeld(11).GetText()
      !Masstab    = TextFeld(12).GetText()
      !BlNr       = TextFeld(13).GetText()
  WEITER

  ZURCK RET
ENDE FUNKTION

HILFE SYMBOL "Allgemein";SKRIPTE_BEISPIELE_ZEICHNUNGEN