VERSION 8000;;8407
* Allg_BspDialogZeichnung.csx  neue Dialoge  29.11.11
* -----------------------------------------------------------------------------
* @filedoc
* @file Allg_BspDialogZeichnung.csx
* @brief neue Dialoge 
* 
* <Dialog mit Feldern fr Dateiauswahl, Blattschnitt, Zeichnungrand und Button 
*  zum Aufrufen eines Unterdialogs. 
*  Der Button ist ein Objekt der eigenen Klasse /MY_BUTTON/, abgeleitet von der 
*  Klasse /DLG_BUTTON/. Er startet einen Unterdialog mit Feldern fr Gestaltung 
*  (Farb-, Stift-, Strichauswahl etc.). >
*
* -----------------------------------------------------------------------------
* Copyright (C) IB&T
* 
* Gewhrleistung und Nutzung
* 
* Die Nutzung des Skriptes erfolgt stets auf eigene Gefahr. IB&T bernimmt keine
* Gewhr dafr, dass die Nutzung dieses Skriptes zu Ihrem gewnschten Ergebnis
* fhrt. Da CardScripte vorhandene Projektdaten durch Direktzugriff auf die
* jeweiligen Datenbanken auch ohne weitere Sicherheitsabfragen unbemerkt verndern
* oder lschen knnen, erfordert eine Nutzung entsprechende Kenntnisse und groe
* Sorgfalt. IB&T haftet nicht fr eventuell entstehende Datenverluste und
* Folgeschden, die durch die Nutzung von CardScripten entstehen.
*
* -----------------------------------------------------------------------------
* @author CK
* @endfiledoc
* -----------------------------------------------------------------------------
* @history
* -----------------------------------------------------------------------------
* 
BILDSCHIRM GRAFIK
*
* Deklarationen
SYMBOLE * Ret;!DatName;!BlattName;!ObjName;!RandName
SYMBOLE * BFarbe;Rot;Gruen;Blau;Stiftnummer;Strich;SymbNr;TextFont;!Material1;!Oberflaeche1

* Dialogfunktion aufrufen
Zeichnung_DIALOG()

* Ergebnis
WENN Ret DANN
  MELDE " Blatt: #";!BlattName
  MELDE " PLT-Datei: #";!DatName
  MELDE " Zeichnungsobjekt: #";!ObjName
  MELDE " Zeichnungsrand: #";!RandName
  MELDE " RGB-Farbe: #-#-#";Rot;Gruen;Blau
  MELDE " Bildschirmfarbe: #";BFarbe
  MELDE " Stift: #";Stiftnummer
  MELDE " Strichart: #";Strich
  MELDE " Schriftart: #";TextFont
  MELDE " Material: #";!Material1
  MELDE " Oberflche: #";!Oberflaeche1
SONST 
  MELDE " Dialog abgebrochen"
WEITER
STOP
* -----------------------------------------------------------------------------
* @function Zeichnung_DIALOG
* @brief <Dialog mit Feldern fr Dateiauswahl, Blattschnitt, Zeichnungrand und Button 
*         zum Aufrufen eines Unterdialogs. 
*         Die Dialogfhrung wird durch den Unterdialog unterbrochen, Prfung erfolgt erst am Ende.>
* @ingroup
* @author Ch
* @endfunction
FUNKTION Zeichnung_DIALOG:
  * -----------------------------------
  SYMBOLE /DLG_WINDOW/ Dialog
  SYMBOLE /DLG_FILENAME/  Datei
  SYMBOLE /DLG_SHEET/    BLATT
  SYMBOLE /DLG_SHEETBORDER/  Rand
  SYMBOLE /DLG_PLTOBJECT/    ZObjekt
  SYMBOLE /MY_BUTTON/ Dialog2
  EXTERN * Ret; !DatName;!BlattName;!ObjName;!RandName

*..................Werte vorbelegen
  !ObjName = ""
  !RandName = ""

*..................Dialog anlegen
  Dialog =   NEWOBJECT /DLG_WINDOW/
  Dialog.SetCaption("Zeichnung und Gestaltung")

*..................Feld fr Dateinamen und Bezeichnung
  Datei = NewObject /DLG_FILENAME/
  Datei.SetLabel("PLT-Datei:")
  Datei.SetPattern("*.plt")
  Datei.FixExtension()
  Datei.SetName("NeueZeichnung.PLT")
  Datei.SetDescription(" ")
  Datei.EnableNew()
  Dialog.AddField(Datei)
*..................Feld fr Blattschnitt mit Auswahlbutton (Liste und Grafik)
  Blatt = NewObject /DLG_SHEET/ 
  Blatt.SetName(" ")
  BLATT.GetName()
  Blatt.SetLabel("Blatt:")
  Blatt.SetId(31)
  Dialog.AddField(Blatt)
*..................Feld fr Zeichnungsobjektauswahl
  ZObjekt = NewObject /DLG_PLTOBJECT/
  ZObjekt.SetLabel("Zeichnungsobjekt:")
  ZObjekt.SetSize(50)
  ZObjekt.EnableBlank()                  | Feld kann leer bleiben 	
  ZObjekt.SetName(!ObjName)
  Dialog.AddField(ZObjekt)
*..................Feld fr Zeichnungsrandauswahl
  Rand = NewObject /DLG_SHEETBORDER/
  Rand.SetLabel("Zeichnungsrand:")
  Rand.SetName(!RandName)
  Dialog.AddField(Rand)
*..................Button fr 2. Dialog mit eigener Klasse 
  Dialog2 = NewObject /MY_BUTTON/
  Dialog2.SetId(9001)                                                      
  Dialog2.SetCaption("Gestaltung")
  Dialog.AddButton(Dialog2)

*..................Dialog ausfhren
  Ret = Dialog.DoDialog()

*..................Ergebnis
  WENN Ret DANN
    !DatName = Datei.GetName()
    !BlattName = Blatt.GetName()
    !ObjName = ZObjekt.GetName()
    !RandName = Rand.GetName()
  WEITER
  ZURCK Ret
ENDE FUNKTION 
* -----------------------------------------------------------------------------
* @class /MY_BUTTON/
* @brief <eigene Klasse fr Dialog, der ber den Button gestartet wird
* @       abgelaitet von der Klasse /DLG_BUTTON/  >
* @ingroup
* @author Ch
* @endclass
KLASSE /MY_BUTTON/; /DLG_BUTTON/
  * -----------------------------------------------------------------------------
  * @function Push
  * @brief <wird vom Dialogsystem aufgerufen wenn der Button gedrckt wird>
  *
  * @ingroup
  * @author Ch
  * @endfunction
  FUNKTION {long} Push:
    VERZWEIGE GetId()
    ZWEIG 9001
      Gestaltung_Dialog()
    Ende VERZWEIGE 
  ENDE FUNKTION 
  * -----------------------------------------------------------------------------
  * @function Gestaltung_Dialog
  * @brief <Dialog mit Feldern fr Gestaltung (Farb-, Stift-, Strichauswahl etc.) >
  *
  * @ingroup
  * @author Ch
  * @endfunction
  FUNKTION Gestaltung_Dialog:
    SYMBOLE /DLG_WINDOW/ Dialog
    SYMBOLE /DLG_COLOR/ Farbe
    SYMBOLE /DLG_RGBCOLOR/ RGB
    SYMBOLE /DLG_PEN/ Stift
    SYMBOLE /DLG_LINESTYLE/ Strichart
    SYMBOLE /DLG_SYMBOL/ Symbol
    SYMBOLE /DLG_FONT/ Font
    SYMBOLE /DLG_MATERIAL/ Material
    SYMBOLE /DLG_SURFACE/  Surface
    EXTERN * Ret;BFarbe;Rot;Gruen;Blau;Stiftnummer;Strich;SymbNr;TextFont;!Material1;!Oberflaeche1 

*..................Dialog anlegen
    Dialog =  NEWOBJECT /DLG_WINDOW/
    Dialog.SetCaption("Gestaltungsparameter")

*..................Feld fr Bildschirmfarbe mit Auswahl
    Farbe = NewObject /DLG_COLOR/
    Farbe.SetNumber(55)
    Farbe.SetId(21)
    Farbe.SetLabel("Bildschirmfarbe:")
    Dialog.AddField(Farbe)
*..................Feld fr RGB-Farbe mit Auswahl
    RGB = NewObject /DLG_RGBCOLOR/
    RGB.SetRed(55)
    RGB.SetGreen(66)
    RGB.SetBlue(77)
    RGB.SetId(22)
    RGB.SetLabel("RGB-Farbe:")
    Dialog.AddField(RGB)
*..................Feld fr Stift mit Auswahl
    Stift = NewObject /DLG_PEN/
    Stift.SetNumber(4)
    Stift.EnableColorNeutral()
    Stift.SetId(23)
    Stift.SetLabel("Stift:")
    Dialog.AddField(Stift)
*..................Feld fr Strichart mit Auswahl
    Strichart = NewObject /DLG_LINESTYLE/
    Strichart.SetNumber(1)
    Strichart.SetId(24)
    Strichart.SetLabel("Strichart:")
    Dialog.AddField(Strichart)
*..................Feld fr Symbolnummer mit Auswahl
    Symbol = NewObject /DLG_SYMBOL/
    Symbol.SetNumber(1)
    Symbol.SetId(25)
    Symbol.SetLabel("Symbol:")
    Dialog.AddField(Symbol)
*..................Feld fr Textfont mit Auswahl
    Font = NewObject /DLG_FONT/
    Font.SetNumber(100)
    Font.SetId(26)
    Font.SetLabel("Schriftart:")
    Dialog.AddField(Font)
*..................Feld fr Material mit Auswahl
    Material = NewObject /DLG_MATERIAL/ 
    Material.SetName(" ")
    Material.SetLabel("Material:")
    Material.SetId(29)
    Dialog.AddField(Material)
*..................Feld fr Oberflche mit Auswahl
    Surface = NewObject /DLG_SURFACE/  
    Surface.SetName(" ")
    Surface.SetLabel("Oberflche:")
    Surface.SetId(30)
    Dialog.AddField(Surface)
    
*..................Dialog ausfhren
    Ret = Dialog.DoDialog()
    
*..................Ergebnis
    WENN Ret DANN
      BFarbe = Farbe.GetNumber()
      Rot = RGB.GetRed()
      Gruen=RGB.GetGreen()
      Blau = RGB.GetBlue()
      Stiftnummer = Stift.GetNumber()
      Strich = Strichart.GetNumber()
      SymbNr = Symbol.GetNumber()
      Textfont = Font.GetNumber()
      !Material1 = Material.GetName()
      !Oberflaeche1 = Surface.GetName()
    WEITER
  ENDE FUNKTION
  * -----------------------------------------------------------------------------
ENDE KLASSE  
  * -----------------------------------------------------------------------------
